(defun name-list3 (&optional names &key (show t) (title "NameList") 
                             (size '(125 250)) (location '(100 100)) 
                             (vertical t) (in nil in?) 
                             (style 0) (help-only nil) 
                             (symbols t) (content-only nil))
"Args: &OPTIONAL NAMES &KEY (SHOW T) (TITLE \"NAMELIST\") (SIZE (125 250)) (LOCATION (100 100)) (VERTICAL T) (IN NIL IN?) (HELP-ONLY NIL) (SYMBOLS NIL)
Makes a namelist of NAMES with button bar by using containers. Always has horizontal button bar with help button. By default has IN OUT DROP and RESET buttons on vertical bar (horizontal bar when VERTICAL is NIL). Only has help button if HELP-ONLY is T (forces VERTICAL to be NIL)."
  (let ((nl (send name-list-proto3 :new names :help-only help-only
                  :show show :title title :size size :location location 
                  :in in :in? in? :symbols symbols
                  :style style :vertical vertical :content-only content-only)))
    (when show (send nl :show-window)
          (apply #'send nl :size size)
          (send nl :pop-out (send nl :pop-out?)))
    nl))



(defproto name-list-proto3 '(in in? pop-out? names help-only) () vista-scatterplot-proto)

(defmeth name-list-proto3 :in (&optional (objid nil set))
  (if set (setf (slot-value 'in) objid))
  (slot-value 'in))

(defmeth name-list-proto3 :in? (&optional (logical nil set))
  (if set (setf (slot-value 'in?) logical))
  (slot-value 'in?))

(defmeth name-list-proto3 :pop-out? (&optional (logical nil set))
  (if set (setf (slot-value 'pop-out?) logical))
  (slot-value 'pop-out?))

(defmeth name-list-proto3 :names (&optional (str-list nil set))
  (if set (setf (slot-value 'names) str-list))
  (slot-value 'names))

(defmeth name-list-proto3 :help-only (&optional (logical nil set))
  (if set (setf (slot-value 'help-only) logical))
  (slot-value 'help-only))

(defmeth name-list-proto3 :add-grid ()
  )

    (defmeth name-list-proto3 :adjust-to-data ()
      (send self :x-axis nil)
      (send self :y-axis nil)
      (send self :range 0 -.1 1)
      (send self :range 1 (floor (* -1 (/ (fourth (send self :content-rect)) 21))) .5)
      )


(defmeth name-list-proto3 :isnew 
  (names &key (title "NameList") (show t) (in nil in??) (in? nil in???) (help-only nil)
         (location '(50 50)) (size '(250 100)) (go-away t) (menu nil) (top-most t)
         (black-on-white t) (has-v-scroll nil) (has-h-scroll nil) (symbols symbols)
         (content-only nil))
  (let* ((actcon *active-container*)
         (in? (if in??? in? in??))
         (pop-out (cond 
                    ((not in?)    (enable-container *desktop-container*) t) ;poped out
                    ((not in)     (disable-container)                  nil) ;in xlispstat
                    ((objectp in) (enable-container in)                 in) ;in IN
                    ((and (equal t in) 
                          (objectp *active-container*)) *active-container*) ;in actcon       
                    (t            (enable-container self)   t)))            ;in desktop
         (container (if (equal pop-out t) *desktop-container* pop-out))
         (pop-out (not (not pop-out)))
         (object (call-next-method 2 
                                   :variable-labels '("Names") :point-labels names
                                   :connect nil :container container :show nil
                                   :top-most top-most :pop-out pop-out
                                   :location location :size size :new-x nil :new-y nil
                                   :lines nil :menu menu :title title 
                                   :legend1 nil :legend2 nil :go-away go-away
                                   :content-only content-only))
         (over (first (send object :overlays)))
         )
    (send self :in in)
    (send self :in? in?)
    (when (and (numberp names) (> names 0))
          (setf names (mapcar #'(lambda (i) (format nil "Label~d" i)) (iseq names))))
    (send self :names names)
    (send self :menu menu)
    (send self :help-only help-only)
    (send self :x-axis nil)
    (send self :y-axis nil)
    (send self :pop-out? pop-out)
    (send self :showing-labels t)
    (send self :margin 0 20 0 0)
    (send self :legend1 " ")
    (send self :legend2 " ")
    (send self :showing-labels t)
    (send over :remove-button ':mouse-mode)
    (send over :remove-button ':pop)
    (send over :remove-button ':zoom)
    
    (when (> (length names) 0)
          (send self :add-points (list (repeat 0 (length names))
                                       (* -1 (iseq (length names)))) :color 'blue)
          (send self :point-label (iseq (length names)) names)
          (send self :point-state (iseq (length names)) 'hilited))
    (send self :adjust-to-data)
    ))
      (name-list3 (list "forrest" "patty" "debra" "laura" "becky" "lee" "matthew"))